(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9863,        374]*)
(*NotebookOutlinePosition[     10706,        401]*)
(*  CellTagsIndexPosition[     10662,        397]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 8.3  .1 . \ Ren' 
        s\ on\ weakly\ singular\ equation\ *) \[IndentingNewLine]\(k[x_, \ 
          s_] := \((x - s)\)^\((\(-1\)/3)\);\)\), "\[IndentingNewLine]", 
    \(\(\[Phi][x_] := x^2\ \((1 - x)\)^2;\)\), "\[IndentingNewLine]", 
    \(int = Integrate[k[x, s]*\[Phi][s], {s, \ 0, 1}]\)}], "Input"],

Cell[BoxData[
    \(\(3\ x\^\(2/3\)\ \((693\ x\^2 - 1134\ x\^3 + 486\ x\^4)\)\)\/3080 - \(3\
\ \((\(-1\) + x)\)\^\(2/3\)\ \((45 + 72\ x + 207\ x\^2 - 810\ x\^3 + 486\ \
x\^4)\)\)\/3080\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][x] - 0.1*int\)], "Input"],

Cell[BoxData[
    \(\((1 - x)\)\^2\ x\^2 - 
      0.1`\ \((\(3\ x\^\(2/3\)\ \((693\ x\^2 - 1134\ x\^3 + 486\ \
x\^4)\)\)\/3080 - \(3\ \((\(-1\) + x)\)\^\(2/3\)\ \((45 + 72\ x + 207\ x\^2 - \
810\ x\^3 + 486\ x\^4)\)\)\/3080)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\( (*\ This\ is\ f[x]\ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Note\ that\ for\ n = 0, \ 
      the\ approximate\ values\ of\ \[Phi]tilde_  0[x] = \ f[x]/A_  0[x], \ 
      where\ A_  0[x] = 1.0 - G_  0[x], \ 
      G0[x] = \[IndentingNewLine]\(-\[Lambda]\)\ \(\(Integrate\)\([\)\(deriv\ \
of\ k, for\ s\ from\ 0\ to\ 1\  = \ \(-\[Lambda]\)*\((\((x - 1)\)^\((\(-1\)/
                          3)\) - 
                    x^\((\(-1\)/3)\)\ )\)\)\(\ \)\)*) \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.1] = 
      0.0081 - \ \((0.1)\)*\((0.646330407\ *\((693*\((0.1)\) - 
                      1134*\((0.01)\) + 486*\((0.0001)\))\) - \ 
                2.79650925*\((45 + 72*\((0.1)\) + 207*\((0.01)\) - 
                      810*\((0.001)\) + 496*\((0.0001)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.011741148354425319`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.2] = 
      0.0256 - \ \((0.1)\)*\((1.025985568\ *\((693*\((0.2)\) - 
                      1134*\((0.04)\) + 486*\((0.0016)\))\) - \ 
                2.585321628*\((45 + 72*\((0.2)\) + 207*\((0.04)\) - 
                      810*\((0.008)\) + 496*\((0.0016)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.02767184071881766`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.3] = 
      0.0441 - \ \((0.1)\)*\((1.344421424\ *\((693*\((0.3)\) - 
                      1134*\((0.09)\) + 486*\((0.0081)\))\) - \ 
                2.365120549*\((45 + 72*\((0.3)\) + 207*\((0.09)\) - 
                      810*\((0.027)\) + 496*\((0.0081)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.044482147188585196`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.4] = 
      0.0576 - \ \((0.1)\)*\((1.62865057\ *\((693*\((0.4)\) - 
                      1134*\((0.16)\) + 486*\((0.0256)\))\) - \ 
                2.3134135983*\((45 + 72*\((0.4)\) + 207*\((0.16)\) - 
                      810*\((0.064)\) + 496*\((0.0256)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.05696931896055929`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.5] = 
      0.0625 - \ \((0.1)\)*\((1.889881575\ *\((693*\((0.5)\) - 
                      1134*\((0.25)\) + 486*\((0.0625)\))\) - \ 
                1.889881575*\((45 + 72*\((0.5)\) + 207*\((0.25)\) - 
                      810*\((0.125)\) + 496*\((0.0625)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.06060551644064529`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.6] = 
      0.06576 - \ \((0.1)\)*\((2.3134135983\ *\((693*\((0.6)\) - 
                      1134*\((0.36)\) + 486*\((0.1296)\))\) - \ 
                1.62865057*\((45 + 72*\((0.6)\) + 207*\((0.36)\) - 
                      810*\((0.216)\) + 496*\((0.1296)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.06321313088193115`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.7] = 
      0.0441 - \ \((0.1)\)*\((2.365120549\ *\((693*\((0.7)\) - 
                      1134*\((0.49)\) + 486*\((0.2401)\))\) - \ 
                1.344421424*\((45 + 72*\((0.7)\) + 207*\((0.49)\) - 
                      810*\((0.343)\) + 496*\((0.2401)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.04222041475698016`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.8] = 
      0.0256 - \ \((0.1)\)*\((2.585321628\ *\((693*\((0.8)\) - 
                      1134*\((0.64)\) + 486*\((0.4096)\))\) - \ 
                1.025985568*\((45 + 72*\((0.8)\) + 207*\((0.64)\) - 
                      810*\((0.512)\) + 496*\((0.4096)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.024057952442842596`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0.9] = 
      0.0081 - \ \((0.1)\)*\((2.79650925\ *\((693*\((0.9)\) - 
                      1134*\((0.81)\) + 486*\((0.6561)\))\) - \ 
                1.344421424*\((45 + 72*\((0.9)\) + 207*\((0.481)\) - 
                      810*\((0.729)\) + 496*\((0.6561)\))\)\ )\)/
            3080\)], "Input"],

Cell[BoxData[
    \(0.0034874742224465082`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.1] = 1.0 - 0.1*\((\(-1.035744169\) - 2.154434969)\)\)], "Input"],

Cell[BoxData[
    \(1.3190179138`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.2] = 1.0 - 0.1*\((\(-1.077217345\) - 1.709975947)\)\)], "Input"],

Cell[BoxData[
    \(1.2787193292`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.3] = 1.0 - 0.1*\((\(-1.12624788\) - 1.493801582)\)\)], "Input"],

Cell[BoxData[
    \(1.2620049462`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.4] = 1.0 - 0.1*\((\(-1.185631101\) - 1.7357208808)\)\)], "Input"],

Cell[BoxData[
    \(1.29213519818`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.5] = 1.0 - 0.1*\((\(-1.25992105\) - 1.25992105)\)\)], "Input"],

Cell[BoxData[
    \(1.25198421`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.6] = 1.0 - 0.1*\((\(-1.357208808\) - 1.18561101)\)\)], "Input"],

Cell[BoxData[
    \(1.2542819818`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.7] = 1.0 - 0.1*\((\(-1.493801582\) - 1.82624788)\)\)], "Input"],

Cell[BoxData[
    \(1.3320049462`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.8] = 1.0 - 0.1*\((\(-1.709975947\) - 1.077217345)\)\)], "Input"],

Cell[BoxData[
    \(1.2787193292`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[0.9] = 1.0 - 0.1*\((\(-2.154434969\) - 1.035744169)\)\)], "Input"],

Cell[BoxData[
    \(1.3190179138`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.1] = f[0.1]/A0[0.1]\)], "Input"],

Cell[BoxData[
    \(0.008901432066680488`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.2] = f[0.2]/A0[0.2]\)], "Input"],

Cell[BoxData[
    \(0.02164027717961367`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.3] = f[0.3]/A0[0.3]\)], "Input"],

Cell[BoxData[
    \(0.03524720511003113`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.4] = f[0.4]/A0[0.4]\)], "Input"],

Cell[BoxData[
    \(0.04408928650871967`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.5] = f[0.5]/A0[0.5]\)], "Input"],

Cell[BoxData[
    \(0.04840757252093881`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.6] = f[0.6]/A0[0.6]\)], "Input"],

Cell[BoxData[
    \(0.0503978625214842`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.7] = f[0.7]/A0[0.7]\)], "Input"],

Cell[BoxData[
    \(0.03169689037373948`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.8] = f[0.8]/A0[0.8]\)], "Input"],

Cell[BoxData[
    \(0.018814099305039734`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phitil[0.9] = f[0.9]/A0[0.9]\)], "Input"],

Cell[BoxData[
    \(0.0026439930693581974`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{535, 536},
WindowMargins->{{6, Automatic}, {Automatic, 11}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 341, 5, 75, "Input"],
Cell[2083, 58, 198, 3, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2318, 66, 52, 1, 27, "Input"],
Cell[2373, 69, 240, 4, 83, "Output"]
}, Open  ]],
Cell[2628, 76, 496, 8, 123, "Input"],

Cell[CellGroupData[{
Cell[3149, 88, 322, 6, 139, "Input"],
Cell[3474, 96, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3566, 102, 323, 6, 139, "Input"],
Cell[3892, 110, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3983, 116, 323, 6, 139, "Input"],
Cell[4309, 124, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4401, 130, 323, 6, 139, "Input"],
Cell[4727, 138, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4818, 144, 323, 6, 139, "Input"],
Cell[5144, 152, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5235, 158, 324, 6, 139, "Input"],
Cell[5562, 166, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5653, 172, 323, 6, 139, "Input"],
Cell[5979, 180, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6070, 186, 323, 6, 139, "Input"],
Cell[6396, 194, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6488, 200, 323, 6, 139, "Input"],
Cell[6814, 208, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6907, 214, 89, 1, 27, "Input"],
Cell[6999, 217, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7083, 223, 89, 1, 27, "Input"],
Cell[7175, 226, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7259, 232, 88, 1, 27, "Input"],
Cell[7350, 235, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7434, 241, 90, 1, 27, "Input"],
Cell[7527, 244, 48, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7612, 250, 87, 1, 27, "Input"],
Cell[7702, 253, 45, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7784, 259, 88, 1, 27, "Input"],
Cell[7875, 262, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7959, 268, 88, 1, 27, "Input"],
Cell[8050, 271, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8134, 277, 89, 1, 27, "Input"],
Cell[8226, 280, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8310, 286, 89, 1, 27, "Input"],
Cell[8402, 289, 47, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8486, 295, 61, 1, 27, "Input"],
Cell[8550, 298, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8642, 304, 61, 1, 27, "Input"],
Cell[8706, 307, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8797, 313, 61, 1, 27, "Input"],
Cell[8861, 316, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8952, 322, 61, 1, 27, "Input"],
Cell[9016, 325, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9107, 331, 61, 1, 27, "Input"],
Cell[9171, 334, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9262, 340, 61, 1, 27, "Input"],
Cell[9326, 343, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9416, 349, 61, 1, 27, "Input"],
Cell[9480, 352, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9571, 358, 61, 1, 27, "Input"],
Cell[9635, 361, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9727, 367, 61, 1, 27, "Input"],
Cell[9791, 370, 56, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

